close all;

figure
plot(T,MAX,'LineWidth',1);
xlabel('time (sec)','FontSize',18,'FontWeight','bold');
ylabel('J=f(x,y)','FontSize',18,'FontWeight','bold');
title('Output','FontSize',18,'FontWeight','bold');
grid on;  
set(gca,'FontSize',12,'FontWeight','bold'); 
axis([0 80 -0.5 1.05]);
saveas(gcf,'sps_moving_output.eps','psc2');
axis([0 30 -0.5 1.05]);
saveas(gcf,'sps_moving_output_new.eps','psc2');

figure
plot(X,Y,'LineWidth',1);
hold on;
plot(centerx, centery,'r--','LineWidth',2);
xlabel('x','FontSize',18,'FontWeight','bold');
ylabel('y','FontSize',18,'FontWeight','bold');
title('Vehicle Trajectory for Moving Source','FontSize',18,'FontWeight','bold');
legend('vehicle trajectory','source trajectory')
grid on;  
set(gca,'FontSize',12,'FontWeight','bold'); 
axis([-1.5 1.5 -1.5 1.5]);
saveas(gcf,'sps_moving_trajectory.eps','psc2');


figure
plot(T,Vx,'LineWidth',1);
xlabel('time (sec)','FontSize',18,'FontWeight','bold');
ylabel('V_x','FontSize',18,'FontWeight','bold');
title('Control Input of X-axis','FontSize',18,'FontWeight','bold');
grid on;  
set(gca,'FontSize',12,'FontWeight','bold'); 
saveas(gcf,'sps_moving_vx.eps','psc2');
axis([0 30 -10 8]);
saveas(gcf,'sps_moving_vx_new.eps','psc2');

figure
plot(T,Vy,'LineWidth',1);
xlabel('time (sec)','FontSize',18,'FontWeight','bold');
ylabel('V_y','FontSize',18,'FontWeight','bold');
title('Control Input of Y-axis','FontSize',18,'FontWeight','bold');
grid on;  
set(gca,'FontSize',12,'FontWeight','bold'); 
saveas(gcf,'sps_moving_vy.eps','psc2');
axis([0 30 -12 8]);
saveas(gcf,'sps_moving_vy_new.eps','psc2');

